/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWException;
import filenet.vw.base.VWUDDIBusinessEntity;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.ws.utils.WSConstants;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VWUDDIRegistry {
    public static final int FILTER_NONE = 0;
    public static final int FILTER_BUSINESS_KEY = 1;
    public static final int FILTER_PUBLISH = 2;
    public static final int FILTER_USER = 4;
    public static final String XML_TAG_UDDI_REGISTRY = "UDDIRegistry";
    public static final String XML_ATTRIBUTE_NAME = "name";
    public static final String XML_ATTRIBUTE_INQUIRY_URL = "inquiryURL";
    public static final String XML_ATTRIBUTE_PUBLISH_URL = "publishURL";
    public static final String UDDI_TAG = "UDDIRegistry";
    public static final String XML_ATTRIBUTE_PUBLISH = "publish";
    public static final String XML_ATTRIBUTE_BUSINESS_NAME = "businessName";
    public static final String XML_ATTRIBUTE_BUSINESS_DESCRIPTION = "businessDescription";
    public static final String XML_ATTRIBUTE_BUSINESS_KEY = "businessKey";
    public static final String XML_ATTRIBUTE_USER_NAME = "userName";
    protected String m_sName = null;
    protected String m_sPublishURL = null;
    protected String m_sInquiryURL = null;
    protected Vector m_businessEntities = new Vector();
    protected Element base = null;
    protected boolean m_bPublish = false;

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 19:12:06  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.18  $";
    }

    public VWUDDIRegistry() {
    }

    public VWUDDIRegistry(String name, String s_inquiryURL, String s_publishURL) throws Exception {
        this.m_sName = name.trim();
        this.m_sInquiryURL = s_inquiryURL.trim();
        this.m_sPublishURL = s_publishURL.trim();
    }

    public VWUDDIRegistry(Element uddiRegistryEle) throws Exception {
        if (uddiRegistryEle == null) {
            throw new VWException("filenet.vw.base.VWUDDIRegistry.constructor.DOM", "Element is null");
        }
        this.m_sName = uddiRegistryEle.getAttribute(XML_ATTRIBUTE_NAME);
        this.m_sInquiryURL = uddiRegistryEle.getAttribute(XML_ATTRIBUTE_INQUIRY_URL);
        this.m_sPublishURL = uddiRegistryEle.getAttribute(XML_ATTRIBUTE_PUBLISH_URL);
        String sPublish = uddiRegistryEle.getAttribute(XML_ATTRIBUTE_PUBLISH);
        if (sPublish.compareTo("1") == 0) {
            this.m_bPublish = true;
        }
        NodeList nodeList = uddiRegistryEle.getChildNodes();
        String nodeName = null;
        Node node = null;
        if (nodeList != null) {
            if (this.m_businessEntities == null) {
                this.m_businessEntities = new Vector();
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element elem;
                node = nodeList.item(i);
                if (node == null || !(node instanceof Element) || (nodeName = (elem = (Element)node).getNodeName()).compareTo("VWBusinessEntity") != 0) continue;
                VWUDDIBusinessEntity aVWBusinessEntity = new VWUDDIBusinessEntity(elem);
                this.m_businessEntities.add(aVWBusinessEntity);
            }
        }
    }

    public VWUDDIRegistry(String name, String s_inquiryURL, String s_publishURL, boolean bPublish, String businessName, String businessDescription, String businessKey, String username) throws Exception {
        this.m_sName = name.trim();
        this.m_sInquiryURL = s_inquiryURL.trim();
        this.m_sPublishURL = s_publishURL.trim();
        this.m_bPublish = bPublish;
        if (this.m_businessEntities == null) {
            this.m_businessEntities = new Vector();
        }
        VWUDDIBusinessEntity aVWBusinessEntity = new VWUDDIBusinessEntity(businessName.trim(), this.m_sName, bPublish, businessDescription, businessKey, username);
        this.m_businessEntities.add(aVWBusinessEntity);
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String name) {
        this.m_sName = name.trim();
    }

    public String getPublishURL() {
        return this.m_sPublishURL;
    }

    public void setPublishURL(String s_URL) throws Exception {
        this.m_sPublishURL = s_URL.trim();
    }

    public String getInquiryURL() {
        return this.m_sInquiryURL;
    }

    public void setInquiryURL(String s_URL) throws Exception {
        this.m_sInquiryURL = s_URL.trim();
    }

    public boolean isPublishable() {
        boolean bPublishable = false;
        if (this.m_sPublishURL != null) {
            this.m_sPublishURL = this.m_sPublishURL.trim();
            if (this.m_sPublishURL.length() > 0) {
                bPublishable = true;
            }
        }
        return bPublishable;
    }

    public Vector getBusinessEntityVector() {
        return this.m_businessEntities;
    }

    public void setBusinessEntityVector(Vector businessEntities) {
        this.m_businessEntities = businessEntities;
    }

    public VWUDDIBusinessEntity getVWBusinessEntity(String name) {
        VWUDDIBusinessEntity vwUDDIBusiness = null;
        if (name != null && name.length() > 0 && this.m_businessEntities != null && this.m_businessEntities.size() > 0) {
            boolean bFind = false;
            for (int i = 0; i < this.m_businessEntities.size(); ++i) {
                vwUDDIBusiness = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(i);
                if (name.compareTo(vwUDDIBusiness.getNameString(0)) != 0) continue;
                bFind = true;
                break;
            }
            if (!bFind) {
                vwUDDIBusiness = null;
            }
        }
        return vwUDDIBusiness;
    }

    public VWUDDIBusinessEntity getVWBusinessEntityByKey(String key) {
        VWUDDIBusinessEntity vwUDDIBusiness = null;
        if (key != null && key.length() > 0 && this.m_businessEntities != null && this.m_businessEntities.size() > 0) {
            boolean bFind = false;
            for (int i = 0; i < this.m_businessEntities.size(); ++i) {
                vwUDDIBusiness = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(i);
                if (key.compareTo(vwUDDIBusiness.getBusinessKey()) != 0) continue;
                bFind = true;
                break;
            }
            if (!bFind) {
                vwUDDIBusiness = null;
            }
        }
        return vwUDDIBusiness;
    }

    public int getVWBusinessEntityIndexByKey(String key) {
        int idx = -1;
        if (key != null && key.length() > 0 && this.m_businessEntities != null && this.m_businessEntities.size() > 0) {
            for (int i = 0; i < this.m_businessEntities.size(); ++i) {
                VWUDDIBusinessEntity vwUDDIBusiness = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(i);
                if (key.compareTo(vwUDDIBusiness.getBusinessKey()) != 0) continue;
                idx = i;
                break;
            }
        }
        return idx;
    }

    public VWUDDIBusinessEntity[] getVWBusinessEntities() {
        return this.getVWBusinessEntities(0);
    }

    public VWUDDIBusinessEntity[] getVWBusinessEntities(int filter) {
        Object[] vwBusinessEntityList = null;
        if (this.m_businessEntities != null) {
            Vector<VWUDDIBusinessEntity> v = new Vector<VWUDDIBusinessEntity>();
            int sz = this.m_businessEntities.size();
            for (int i = 0; i < sz; ++i) {
                String key;
                VWUDDIBusinessEntity vwBE = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(i);
                if ((filter & 1) > 0 && ((key = vwBE.getBusinessKey()) == null || key.length() <= 0) || (filter & 2) > 0 && !vwBE.getPublish()) continue;
                if ((filter & 4) > 0) {
                    String user = null;
                    if (vwBE.getName(0) != null) {
                        user = vwBE.getName(0).getValue();
                    }
                    if (user == null || user.length() <= 0) continue;
                }
                v.add(vwBE);
            }
            if (v.size() > 0) {
                vwBusinessEntityList = new VWUDDIBusinessEntity[v.size()];
                v.copyInto(vwBusinessEntityList);
            }
        }
        return vwBusinessEntityList;
    }

    public VWUDDIBusinessEntity getVWBusinessEntity(int idx) {
        if (idx < 0 || idx >= this.m_businessEntities.size()) {
            return null;
        }
        return (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(idx);
    }

    public void setVWBusinessEntity(int idx, VWUDDIBusinessEntity entity) {
        if (this.m_businessEntities == null) {
            this.m_businessEntities = new Vector();
        }
        if (entity != null && idx >= 0 && idx < this.m_businessEntities.size()) {
            this.m_businessEntities.setElementAt(entity, idx);
        } else {
            this.m_businessEntities.add(entity);
        }
    }

    public void setBusinessEntities(VWUDDIBusinessEntity[] entities) {
        if (this.m_businessEntities == null) {
            this.m_businessEntities = new Vector();
        } else {
            this.m_businessEntities.clear();
        }
        if (entities != null && entities.length > 0) {
            for (int i = 0; i < entities.length; ++i) {
                this.m_businessEntities.add(entities[i]);
            }
        }
    }

    public void addBusinessEntity(VWUDDIBusinessEntity businessEntity) {
        if (this.m_businessEntities == null) {
            this.m_businessEntities = new Vector();
        }
        businessEntity.setUDDIRegistry(this.getName());
        businessEntity.setPublish(this.isPublishable());
        this.m_businessEntities.add(businessEntity);
    }

    public void removeBusinessAt(int index) {
        this.m_businessEntities.remove(index);
    }

    public void removeBusiness(String name) {
        VWUDDIBusinessEntity vwBusinessEntity = this.getVWBusinessEntity(name);
        if (vwBusinessEntity != null) {
            this.m_businessEntities.removeElement(vwBusinessEntity);
        }
    }

    public void removeBusinessByKey(String key) {
        int idx = this.getVWBusinessEntityIndexByKey(key);
        if (idx >= 0) {
            this.m_businessEntities.removeElementAt(idx);
        }
    }

    public void removeAllBusiness() {
        this.m_businessEntities.clear();
    }

    private void checkFirstBusinessEntity() {
        if (this.m_businessEntities == null) {
            this.m_businessEntities = new Vector();
        }
        if (this.m_businessEntities.size() == 0) {
            this.m_businessEntities.add(new VWUDDIBusinessEntity());
        }
    }

    public boolean getPublish() {
        return this.m_bPublish;
    }

    public void setPublish(boolean bPublish) {
        this.m_bPublish = bPublish;
    }

    public String getBusinessName() {
        Vector v;
        BusinessEntity bn;
        VWUDDIBusinessEntity vwBusinessEn;
        String businessName = null;
        if (this.m_businessEntities != null && this.m_businessEntities.size() > 0 && (vwBusinessEn = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(0)) != null && (bn = vwBusinessEn.getBusinessEntity()) != null && (v = bn.getNameVector()) != null && v.size() > 0 && v.elementAt(0) != null && v.elementAt(0) instanceof Name) {
            businessName = ((Name)v.elementAt(0)).getValue();
        }
        return businessName;
    }

    public void setBusinessName(String businessName) {
        BusinessEntity bn;
        this.checkFirstBusinessEntity();
        VWUDDIBusinessEntity vwBusinessEn = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(0);
        if (vwBusinessEn != null && (bn = vwBusinessEn.getBusinessEntity()) != null) {
            if (businessName != null && businessName.length() > 0) {
                businessName = businessName.trim();
            }
            Name name = new Name(businessName);
            Vector<Name> v = new Vector<Name>();
            v.add(name);
            bn.setNameVector(v);
        }
    }

    public void setBusinessNameVector(Vector name) {
        BusinessEntity bn;
        this.checkFirstBusinessEntity();
        VWUDDIBusinessEntity vwBusinessEn = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(0);
        if (vwBusinessEn != null && (bn = vwBusinessEn.getBusinessEntity()) != null) {
            bn.setNameVector(name);
        }
    }

    public String getBusinessDescription() {
        Vector v;
        BusinessEntity bn;
        VWUDDIBusinessEntity vwBusinessEn;
        String desc = null;
        if (this.m_businessEntities != null && this.m_businessEntities.size() > 0 && (vwBusinessEn = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(0)) != null && (bn = vwBusinessEn.getBusinessEntity()) != null && (v = bn.getDescriptionVector()) != null && v.size() > 0 && v.elementAt(0) != null && v.elementAt(0) instanceof Description) {
            desc = ((Description)v.elementAt(0)).getValue();
        }
        return desc;
    }

    public void setBusinessDescription(String businessDescription) {
        BusinessEntity bn;
        this.checkFirstBusinessEntity();
        VWUDDIBusinessEntity vwBusinessEn = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(0);
        if (vwBusinessEn != null && (bn = vwBusinessEn.getBusinessEntity()) != null) {
            Vector<Description> descVector = bn.getDescriptionVector();
            if (!(descVector != null && descVector.size() != 0 || businessDescription != null && businessDescription.length() > 0)) {
                return;
            }
            if (descVector == null) {
                descVector = new Vector<Description>();
            }
            if (descVector.size() == 0) {
                descVector.add(new Description(businessDescription));
            } else {
                descVector.setElementAt(new Description(businessDescription), 0);
            }
            bn.setDescriptionVector(descVector);
        }
    }

    public void setBusinessDescriptionVector(Vector description) {
        BusinessEntity bn;
        this.checkFirstBusinessEntity();
        VWUDDIBusinessEntity vwBusinessEn = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(0);
        if (vwBusinessEn != null && (bn = vwBusinessEn.getBusinessEntity()) != null) {
            bn.setDescriptionVector(description);
        }
    }

    public void setBusinessKey(String businessKey) {
        BusinessEntity bn;
        this.checkFirstBusinessEntity();
        VWUDDIBusinessEntity vwBusinessEn = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(0);
        if (vwBusinessEn != null && (bn = vwBusinessEn.getBusinessEntity()) != null) {
            bn.setBusinessKey(businessKey);
        }
    }

    public void setBusinessKeys(String[] businessKeys) throws VWException {
        this.checkFirstBusinessEntity();
        if (businessKeys != null && this.m_businessEntities != null) {
            int keyLength = businessKeys.length;
            int bnSize = this.m_businessEntities.size();
            if (keyLength == bnSize) {
                for (int i = 0; i < keyLength; ++i) {
                    BusinessEntity bn;
                    VWUDDIBusinessEntity vwBusinessEn = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(i);
                    if (vwBusinessEn == null || (bn = vwBusinessEn.getBusinessEntity()) == null) continue;
                    bn.setBusinessKey(businessKeys[i]);
                }
            } else {
                throw new VWException("filenet.vw.base.VWUDDIRegistry.setBusinessKeys", "Number of keys and number of business does not match");
            }
        }
    }

    public String getBusinessKey() {
        BusinessEntity bn;
        VWUDDIBusinessEntity vwBusinessEn;
        String key = null;
        if (this.m_businessEntities != null && this.m_businessEntities.size() > 0 && (vwBusinessEn = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(0)) != null && (bn = vwBusinessEn.getBusinessEntity()) != null) {
            key = bn.getBusinessKey();
        }
        return key;
    }

    public String[] getBusinessKeys() {
        String[] keys = null;
        if (this.m_businessEntities != null) {
            int sz = this.m_businessEntities.size();
            keys = new String[sz];
            for (int i = 0; i < sz; ++i) {
                BusinessEntity bn;
                VWUDDIBusinessEntity vwBusinessEn = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(0);
                if (vwBusinessEn == null || (bn = vwBusinessEn.getBusinessEntity()) == null) continue;
                keys[i] = bn.getBusinessKey();
                if (keys[i] == null || keys[i].length() != 0) continue;
                keys[i] = null;
            }
        }
        return keys;
    }

    public void setAuthorizedUsername(String username) {
        BusinessEntity bn;
        this.checkFirstBusinessEntity();
        VWUDDIBusinessEntity vwBusinessEn = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(0);
        if (vwBusinessEn != null && (bn = vwBusinessEn.getBusinessEntity()) != null) {
            bn.setAuthorizedName(username);
        }
    }

    public String getAuthorizedUsername() {
        BusinessEntity bn;
        VWUDDIBusinessEntity vwBusinessEn;
        String name = null;
        if (this.m_businessEntities != null && this.m_businessEntities.size() > 0 && (vwBusinessEn = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(0)) != null && (bn = vwBusinessEn.getBusinessEntity()) != null) {
            name = bn.getAuthorizedName();
        }
        return name;
    }

    public String getPublishUsername() {
        VWUDDIBusinessEntity vwBusinessEn;
        String name = null;
        if (this.m_businessEntities != null && this.m_businessEntities.size() > 0 && (vwBusinessEn = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(0)) != null) {
            name = vwBusinessEn.getPublishUserName();
        }
        return name;
    }

    public void setPublishUsername(String name) {
        VWUDDIBusinessEntity vwBusinessEn;
        if (this.m_businessEntities != null && this.m_businessEntities.size() > 0 && (vwBusinessEn = (VWUDDIBusinessEntity)this.m_businessEntities.elementAt(0)) != null) {
            vwBusinessEn.setPublishUserName(name);
        }
    }

    public boolean verifyUDDI() {
        if (this.m_sName == null) {
            return false;
        }
        if (this.m_sInquiryURL == null) {
            return false;
        }
        try {
            URL oURL = new URL(this.m_sInquiryURL);
            if (oURL == null) {
                return false;
            }
            URLConnection aURLCN = oURL.openConnection();
            if (aURLCN == null) {
                return false;
            }
            if (this.m_sPublishURL != null && this.m_sPublishURL.length() > 1) {
                oURL = new URL(this.m_sPublishURL);
                if (oURL == null) {
                    return false;
                }
                aURLCN = oURL.openConnection();
                if (aURLCN == null) {
                    return false;
                }
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public String validateUDDI() {
        if (this.m_sName == null || this.m_sName.length() < 1) {
            return VWResource.s_invalidUDDIName;
        }
        if (this.m_sInquiryURL == null || this.m_sInquiryURL.length() <= 0) {
            return VWResource.s_nullUDDIInquiryURL;
        }
        try {
            URL oURL = new URL(this.m_sInquiryURL);
            if (oURL == null) {
                return VWResource.s_invalidUDDIInquiryURL;
            }
            URLConnection aURLCN = oURL.openConnection();
            if (aURLCN == null) {
                return VWResource.s_failedToConnectInquiryURL;
            }
            if (this.m_sPublishURL != null && this.m_sPublishURL.length() > 0) {
                oURL = new URL(this.m_sPublishURL);
                if (oURL == null) {
                    return VWResource.s_invalidUDDIPublishURL;
                }
                aURLCN = oURL.openConnection();
                if (aURLCN == null) {
                    return VWResource.s_failedToConnectPublishURL;
                }
            }
            for (int i = this.m_businessEntities.size() - 1; i >= 0; --i) {
                BusinessEntity bn = ((VWUDDIBusinessEntity)this.m_businessEntities.elementAt(i)).getBusinessEntity();
                if (bn == null || bn.getNameVector() != null) continue;
                this.m_businessEntities.removeElementAt(i);
            }
        }
        catch (Exception ex) {
            return ex.getLocalizedMessage();
        }
        return null;
    }

    public String toXML() {
        if (this.m_sName == null) {
            return null;
        }
        String sXML = "<UDDIRegistry name=\"" + (this.m_sName == null ? "" : WSConstants.UTF8Encode(this.m_sName)) + "\"" + " " + XML_ATTRIBUTE_INQUIRY_URL + "=\"" + (this.m_sInquiryURL == null ? "" : WSConstants.UTF8Encode(this.m_sInquiryURL)) + "\"" + " " + XML_ATTRIBUTE_PUBLISH_URL + "=\"" + (this.m_sPublishURL == null ? "" : WSConstants.UTF8Encode(this.m_sPublishURL)) + "\">" + "</" + "UDDIRegistry" + ">";
        return sXML;
    }

    public void releaseResources() {
        this.m_sName = null;
        this.m_sPublishURL = null;
        this.m_sInquiryURL = null;
        this.m_businessEntities = null;
    }

    public void saveToXML(Element parent) {
        this.base = parent.getOwnerDocument().createElement("UDDIRegistry");
        if (this.m_sName != null) {
            this.base.setAttribute(XML_ATTRIBUTE_NAME, this.m_sName);
        }
        if (this.m_sInquiryURL != null) {
            this.base.setAttribute(XML_ATTRIBUTE_INQUIRY_URL, this.m_sInquiryURL);
        }
        if (this.m_sPublishURL != null) {
            this.base.setAttribute(XML_ATTRIBUTE_PUBLISH_URL, this.m_sPublishURL);
        }
        this.base.setAttribute(XML_ATTRIBUTE_PUBLISH, this.m_bPublish ? "1" : "0");
        if (this.m_businessEntities != null) {
            for (int i = 0; i < this.m_businessEntities.size(); ++i) {
                ((VWUDDIBusinessEntity)this.m_businessEntities.elementAt(i)).setContacts(null);
                ((VWUDDIBusinessEntity)this.m_businessEntities.elementAt(i)).saveToXML(this.base);
            }
        }
        parent.appendChild(this.base);
    }

    public static VWUDDIRegistry parseXML_v_0(Node uddiRegistryNode) throws Exception {
        if (uddiRegistryNode == null) {
            return null;
        }
        try {
            Element uddiRegistryEle = (Element)uddiRegistryNode;
            String sUDDIName = uddiRegistryEle.getAttribute(XML_ATTRIBUTE_NAME);
            String sInquiryURL = uddiRegistryEle.getAttribute(XML_ATTRIBUTE_INQUIRY_URL);
            String sPublishURL = uddiRegistryEle.getAttribute(XML_ATTRIBUTE_PUBLISH_URL);
            String sPublish = uddiRegistryEle.getAttribute(XML_ATTRIBUTE_PUBLISH);
            String sBusinessName = uddiRegistryEle.getAttribute(XML_ATTRIBUTE_BUSINESS_NAME);
            String sBusinessDescription = uddiRegistryEle.getAttribute(XML_ATTRIBUTE_BUSINESS_DESCRIPTION);
            String sBusinessKey = uddiRegistryEle.getAttribute(XML_ATTRIBUTE_BUSINESS_KEY);
            String sUsername = uddiRegistryEle.getAttribute(XML_ATTRIBUTE_USER_NAME);
            boolean bPublish = false;
            if (sPublish.equals("1")) {
                bPublish = true;
            }
            VWUDDIRegistry theUDDIRegistry = new VWUDDIRegistry(WSConstants.UTF8Decode(sUDDIName), WSConstants.UTF8Decode(sInquiryURL), WSConstants.UTF8Decode(sPublishURL), bPublish, WSConstants.UTF8Decode(sBusinessName), WSConstants.UTF8Decode(sBusinessDescription), WSConstants.UTF8Decode(sBusinessKey), WSConstants.UTF8Decode(sUsername));
            return theUDDIRegistry;
        }
        catch (Exception ex) {
            throw new VWException("filenet.vw.base.VWUDDIRegistry.ParseXML_v_0", "Failed to parse UDDI registry XML. {0}", ex.getMessage());
        }
    }

    public String toString() {
        return this.m_sName;
    }
}

